#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define MAX_ITERATIONS 10000

typedef struct {
    long long x, y;
    int index;
} Vektor;

void resavaj(int N, Vektor *vektori, double Dx, double Dy, long long *max_kvadrat, int *izabrano);

int main() {
    srand(time(NULL));

    int N;
    if (scanf("%d", &N) != 1 || N < 1) return 1;

    Vektor *vektori = (Vektor *)malloc(N * sizeof(Vektor));
    int *izabrano_best = (int *)calloc(N, sizeof(int));
    
    if (vektori == NULL || izabrano_best == NULL) {
        free(vektori); free(izabrano_best);
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) {
            free(vektori); free(izabrano_best);
            return 1;
        }
        vektori[i].index = i + 1;
    }

    long long max_kvadrat = 0;

    resavaj(N, vektori, 1.0, 0.0, &max_kvadrat, izabrano_best);
    resavaj(N, vektori, 0.0, 1.0, &max_kvadrat, izabrano_best);
    
    for (int iter = 0; iter < MAX_ITERATIONS; iter++) {
        double theta = ((double)rand() / RAND_MAX) * 2.0 * M_PI;
        
        double Dx = cos(theta);
        double Dy = sin(theta);
        
        resavaj(N, vektori, Dx, Dy, &max_kvadrat, izabrano_best);
    }
    
    int k = 0;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            k++;
        }
    }

    printf("%d\n", k);
    
    int prvi = 1;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            if (!prvi) {
                printf(" ");
            }
            printf("%d", vektori[i].index);
            prvi = 0;
        }
    }
    if (k > 0) {
        printf("\n");
    }

    free(vektori); 
    free(izabrano_best);

    return 0;
}

void resavaj(int N, Vektor *vektori, double Dx, double Dy, long long *max_kvadrat, int *izabrano) {
    long long Rx = 0;
    long long Ry = 0;
    
    int *izabrano_temp = (int *)calloc(N, sizeof(int));
    if (izabrano_temp == NULL) return; 

    for (int i = 0; i < N; i++) {
        long long xi = vektori[i].x;
        long long yi = vektori[i].y;
        double dot_product = (double)xi * Dx + (double)yi * Dy;

        if (dot_product > 0) {
            Rx += xi;
            Ry += yi;
            izabrano_temp[i] = 1;
        } else {
            izabrano_temp[i] = 0;
        }
    }

    long long novi_kvad = Rx * Rx + Ry * Ry;

    if (novi_kvad > *max_kvadrat) {
        *max_kvadrat = novi_kvad;
        for (int i = 0; i < N; i++) {
            izabrano[i] = izabrano_temp[i];
        }
    }

    free(izabrano_temp);
}